
(function () {
  // ================= KONFIGURASI =================
  const targetURL = "https://otieu.com/4/9833019"; // redirect tombol CONTINUE
  const altURL = "https://otieu.com/4/9833019"; // redirect saat klik X
  const DURATION_SEC = 3; // durasi hitung mundur
  // ===============================================

  function createRedirectOverlay() {
    // Animasi CSS
    const style = document.createElement("style");
    style.textContent = `
      @keyframes fadeIn { from {opacity:0} to {opacity:1} }
      .overlay-adfly {
        position: fixed; inset: 0; background: rgba(0,0,0,0.85);
        display: flex; justify-content: center; align-items: center;
        z-index: 9999999; animation: fadeIn .4s ease;
      }
      .ad-box {
        background: #fff; padding: 25px; border-radius: 10px;
        box-shadow: 0 6px 15px rgba(0,0,0,0.4);
        text-align: center; max-width: 400px; width: 90%;
        font-family: Arial, sans-serif; position: relative;
      }
      .close-btn {
        position: absolute; top: -10px; right: -10px;
        background: #ff2b2b; color: #fff; width: 28px; height: 28px;
        border-radius: 50%; font-size: 18px; font-weight: bold;
        line-height: 28px; text-align: center; cursor: pointer;
        box-shadow: 0 2px 6px rgba(0,0,0,0.3);
        transition: transform .2s, background-color .2s;
      }
      .close-btn:hover { transform: scale(1.2); background: #ff0000; }
      .progress-wrap {
        width: 100%; height: 8px; background: #eee;
        border-radius: 5px; overflow: hidden; margin: 15px 0;
      }
      .progress-bar {
        height: 100%; width: 0%; background: linear-gradient(90deg,#f7b733,#fc4a1a);
        transition: width .1s linear;
      }
      .countdown {
        color: #666; font-size: 14px; margin-bottom: 12px;
      }
      .continue-btn {
        background: #9ecaa9; color: #fff; border: none; border-radius: 5px;
        padding: 12px 24px; font-size: 16px; cursor: not-allowed;
        transition: background .3s, transform .2s;
      }
      .continue-btn.active {
        background: #28a745; cursor: pointer; box-shadow: 0 6px 14px rgba(40,167,69,.35);
      }
      .continue-btn.active:hover {
        background: #218838; transform: scale(1.05);
      }
    `;
    document.head.appendChild(style);

    // Buat elemen
    const overlay = document.createElement("div");
    overlay.className = "overlay-adfly";

    const box = document.createElement("div");
    box.className = "ad-box";

    const closeBtn = document.createElement("div");
    closeBtn.className = "close-btn";
    closeBtn.innerHTML = "&times;";
    closeBtn.onclick = () => { window.location.href = altURL; };

    // Judul dan pesan (versi kamu)
    const title = document.createElement("h2");
    title.textContent = "Attention!";
    title.style.color = "#333";
    title.style.marginBottom = "10px";

    const msg = document.createElement("p");
    msg.textContent = "Click the button below to proceed to the content.";
    msg.style.color = "#555";
    msg.style.marginBottom = "20px";

    // Progress bar & countdown
    const progressWrap = document.createElement("div");
    progressWrap.className = "progress-wrap";
    const progressBar = document.createElement("div");
    progressBar.className = "progress-bar";
    progressWrap.appendChild(progressBar);

    const countdown = document.createElement("div");
    countdown.className = "countdown";
    countdown.textContent = `Please wait ${DURATION_SEC}s`;

    // Tombol Continue
    const button = document.createElement("button");
    button.className = "continue-btn";
    button.textContent = "CONTINUE";
    button.disabled = true;

    // Susun elemen
    box.appendChild(closeBtn);
    box.appendChild(title);
    box.appendChild(msg);
    box.appendChild(progressWrap);
    box.appendChild(countdown);
    box.appendChild(button);
    overlay.appendChild(box);
    document.body.appendChild(overlay);

    // Countdown dan aktivasi tombol
    const start = Date.now();
    const totalMs = DURATION_SEC * 1000;

    function tick() {
      const elapsed = Date.now() - start;
      const progress = Math.min((elapsed / totalMs) * 100, 100);
      progressBar.style.width = progress + "%";
      const remain = Math.ceil((totalMs - elapsed) / 1000);
      if (remain > 0) {
        countdown.textContent = `Please wait ${remain}s`;
        requestAnimationFrame(tick);
      } else {
        countdown.textContent = "Ready";
        button.disabled = false;
        button.classList.add("active");
        button.onclick = () => window.location.href = targetURL;
      }
    }
    tick();
  }

  // Jalankan setelah DOM siap
  if (document.readyState === "loading") {
    document.addEventListener("DOMContentLoaded", createRedirectOverlay);
  } else {
    createRedirectOverlay();
  }
})();

